<?php
namespace App\Exports;

use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class DynamicTableExport implements FromCollection, WithHeadings
{
    protected $table;

    // Constructor to initialize the table name
    public function __construct($table)
    {
        $this->table = $table;
    }

    // Fetching the headings dynamically from the first row
    public function headings(): array
    {
        // Fetch the first row to get the column names
        $firstRow = DB::table($this->table)->first();
        return $firstRow ? array_keys((array) $firstRow) : [];
    }

    // Fetch only the first 100 records from the table
    public function collection()
    {
        return DB::table($this->table)
            ->orderBy('id', 'desc') // Adjust this if you want to order by another column (e.g., 'created_at')
            ->limit(1000000)
            ->get();
    }
}
