<?php
namespace App\WebSocket;

use App\Models\Command;
use Ratchet\MessageComponentInterface;
use Ratchet\ConnectionInterface;
use Illuminate\Support\Facades\DB;
use React\Socket\Connection as ReactConnection;  // Use ReactPHP connection


use App\Traits\HardWareSocketTrait;

class Chat implements MessageComponentInterface {
    protected $clients;
    private static $instance = null;
    protected $connectionsByGlobalId;
    protected $adminConnections; // Store admin connections
    use HardWareSocketTrait;

    public function __construct()
    {
        $this->clients = new \SplObjectStorage;
        $this->connectionsByGlobalId = [];
        $this->adminConnections = [];
    }

    public static function getInstance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    // Check if the device is authorized
    private function isAuthorized($gid)
    {
        try {
            $device = DB::table('meter_visuals')->where('global_device_id', $gid)->first();
            return $device; // Return the device data if found
        } catch (\Exception $e) {
            echo "Unauthorized connection attempt: {$e->getMessage()}\n";
            return null;
        }
    }

    // Check if the server is authorized
    private function isServerAuthorized($serverToken)
    {
        $authorizedServerToken = env('YOUR_SERVER_SECRET_FOR_SOCKET_CONNECTION'); // Server secret token
        return $serverToken === $authorizedServerToken;
    }


    public function onOpen(ConnectionInterface $conn)
    {
        $queryParams = $conn->httpRequest->getUri()->getQuery();
        parse_str($queryParams, $queryArray);
        // testing purpose

        // testing purpose end

        $gid = isset($queryArray['gid']) ? $queryArray['gid'] : null;
        $serverToken = isset($queryArray['server_token']) ? $queryArray['server_token'] : null;
        $isAdmin = isset($queryArray['admin']) && $queryArray['admin'] == 'true'; // Identify admin
        $companyId = isset($queryArray['company']) ? $queryArray['company'] : null;

        if ($companyId) {
            switchTenantDatabase($companyId);
        } else {
            throw new \Exception("Company ID missing in connection");
        }



        if ($serverToken) {
            if ($this->isServerAuthorized($serverToken)) {


                $conn->is_server = true;
                $conn->gid = $gid;
                $conn->companyId = $companyId;
                $this->clients->attach($conn);
                $this->connectionsByGlobalId[$gid] = $conn;
                $this->setConnectionTimeout($conn);
                if ($isAdmin) {
                    $this->adminConnections[$conn->resourceId] = $conn;
                    echo "Admin connected: {$conn->resourceId}\n";
                    // Send the list of connected devices to the admin
                }

                echo "New connection! ({$conn->resourceId}) from device {$gid}\n";
                // echo "New server connection! ({$conn->resourceId})\n";
            } else {
                $conn->close();
                // echo "Unauthorized server connection attempt: {$conn->resourceId}\n";
            }
        } else if ($gid) {
            if ($this->isAuthorized($gid)) {
                $conn->gid = $gid;
                $conn->companyId = $companyId;  // Store tenant company id
                $this->clients->attach($conn);  // Attach the connection object

                // Store connection in MySQL
                DB::table('websocket_connections')->updateOrInsert(
                    ['global_device_id' => $gid], // Conditions to check if the record exists (i.e., by global_device_id)
                    ['resource_id' => $conn->resourceId] // Data to insert or update
                );
                $this->connectionsByGlobalId[$gid] = $conn;
                $this->setConnectionTimeout($conn);
                $this->sendDeviceListToAdmin();
                $this->sendQuedCommandToDevice($this->connectionsByGlobalId[$gid],$gid);

                // $deviceStatus = DB::table('transformer') // Change 'devices' to your actual table name
                //                 ->where('trid', $gid)
                //                 ->select('status')
                //                 ->first(); // Assuming the status column is named 'status'
                // Send the last known status back to the device
                // if ($deviceStatus) {
                // $dev_data=$this->get_info($gid);
                // $msg=['gid'=>$gid,'at'=>'data','d'=>$dev_data];
                // $conn->send(json_encode(socket_data($msg))); // Send the status to the device
                // }
                echo "New connection! ({$conn->resourceId}) from device {$gid}\n";
            } else {
                $conn->close();
                echo "Unauthorized connection attempt: ({$conn->resourceId}) from device {$gid}\n";
            }
        } else {
            $conn->close();
            echo "Unauthorized connection attempt (no device or server token).\n";
        }
    }

    public function send_logs_to_server($from,$data)
    {
        if (isset($this->connectionsByGlobalId['server_'.$data['gid']])) { // if dashboard need data for real time
            $new_data=$data;
            $new_data['gid']='server_'.$data['gid'];
            $this->processCommand($from,$new_data); // send command
        }
    }
    function crc16_ibm(string $data): int
    {
        $crc = 0xFFFF;
        $len = strlen($data);

        for ($i = 0; $i < $len; $i++) {
            $crc ^= ord($data[$i]);
            for ($j = 0; $j < 8; $j++) {
                $crc = ($crc & 0x0001) ? (($crc >> 1) ^ 0xA001) : ($crc >> 1);
            }
        }
        return $crc & 0xFFFF;
    }

    function unpack_raw_data_le(string $binaryData): bool
    {
        /* constants -------------------------------------------------------- */
        $DEVICE_ID_LEN     = 20;
        $CHANNEL_GROUP_LEN = 1;
        $CRC_LEN           = 2;
        $VALUES_PER_SAMPLE = 6;   // v1 i1 v2 i2 v3 i3
        $BYTES_PER_VALUE   = 2;   // 16-bit little-endian
        $BYTES_PER_SAMPLE  = $VALUES_PER_SAMPLE * $BYTES_PER_VALUE;

        /* quick sanity check ----------------------------------------------- */
        $dataLen   = strlen($binaryData);
        $headerLen = $DEVICE_ID_LEN + $CHANNEL_GROUP_LEN;
        $payloadLen = $dataLen - $headerLen - $CRC_LEN;

        if ($dataLen < ($headerLen + $CRC_LEN) || $payloadLen % $BYTES_PER_SAMPLE !== 0) {
            return false; // malformed
        }

        /* CRC check -------------------------------------------------------- */
        $crcStored = unpack('v', substr($binaryData, -$CRC_LEN))[1];
        $crcCalc   = $this->crc16_ibm(substr($binaryData, 0, $dataLen - $CRC_LEN));
        if ($crcCalc !== $crcStored) {
            return false; // corrupted frame
        }

        /* header ----------------------------------------------------------- */
        $deviceIdRaw  = substr($binaryData, 0, $DEVICE_ID_LEN);
        $deviceId     = rtrim($deviceIdRaw, "\xFF"); // strip 0xFF padding
        $channelGroup = ord($binaryData[$DEVICE_ID_LEN]);

        /* samples ---------------------------------------------------------- */
        $sampleBlock    = substr($binaryData, $headerLen, $payloadLen);
        $unpacked       = unpack('v*', $sampleBlock); // little-endian
        if ($unpacked === false) {
            return false;
        }

        $numSamples   = count($unpacked) / $VALUES_PER_SAMPLE;
        $rowsToInsert = [];

        DB::table('time_domain_graph_data')
            ->where('device_id', $deviceId)
            ->where('channel_group', $channelGroup)
            ->delete();

        for ($k = 0; $k < $numSamples; $k++) {
            $idx = 1 + $k * $VALUES_PER_SAMPLE;
            $rowsToInsert[] = [
                'device_id'     => $deviceId,
                'channel_group' => $channelGroup,
                'v1' => $unpacked[$idx + 0],
                'i1' => $unpacked[$idx + 1],
                'v2' => $unpacked[$idx + 2],
                'i2' => $unpacked[$idx + 3],
                'v3' => $unpacked[$idx + 4],
                'i3' => $unpacked[$idx + 5],
            ];
        }

        if (!empty($rowsToInsert)) {
            DB::table('time_domain_graph_data')->insert($rowsToInsert);
        }
        return true;
    }

    public function onMessage(ConnectionInterface $from, $msg)
    {
        try {
            if (isset($from->companyId)) {
                switchTenantDatabase($from->companyId);
            } else {
                throw new \Exception("Company ID not found for connection");
            }
        } catch (\Exception $e) {
            echo "DB switch failed on message: " . $e->getMessage() . "\n";
            $from->close();
            return;
        }


        json_decode($msg);
        if(json_last_error() !== JSON_ERROR_NONE)
        {
            $new_msg=$this->unpack_raw_data_le($msg);
            return 1;

        }

        $data = json_decode($msg, true); // Decode the incoming message as an array

        DB::table('logs')->insert([
            'info'=>'dev data',
            'gid'=>$data['gid'],
            'data' => json_encode($data),
        ]);
        $this->send_logs_to_server($from,$data); // send data to server connection for logs and checking

        if (isset($data['at']) && $data['at'] === 'post_data')
        {
            if (isset($data['d']) && $data['a']=='instantaneous')
            {
                $this->storeDynamicCurrents($data); // store data in database

                // if (isset($this->connectionsByGlobalId['server_'.$data['gid']])) { // if dashboard need data for real time
                //     $new_data=$data;
                //     $new_data['gid']='server_'.$data['gid'];
                //     $this->processCommand($from,$new_data); // send command
                // }
            }
            else if (isset($data['d']) && ($data['a']=='extra_log' || $data['a']=='daily_billing' || $data['a']=='monthly_billing' || $data['a']=='load_profile')) {

                $this->do_action($from,$data);
            }

            else{

            }
        }
        elseif (isset($data['at']) && ($data['at'] === 'request' || $data['at'] === 'event'))
        {
            $this->do_action($from,$data);

        }
        // Send order to client
        elseif (isset($data['at']) && $data['at'] === 'order')
        {
            $this->processCommand($from, $data);

        }
        elseif (isset($data['at']) && $data['at'] === 'confirmation')
        {
            // print_r($data);
            $this->removeFromQue($data);
        }
        else
        {
            // echo getType($data['at']);
            // echo '\n';
            // echo $data['at'];
            // echo '\n';
            echo 'Action Type not matched data[at]';
        }
    }

    public function onClose(ConnectionInterface $conn)
    {
        $this->clients->detach($conn); // Detach from SplObjectStorage

        // Remove connection from MySQL
        DB::table('websocket_connections')->where('resource_id', $conn->resourceId)->delete();
        if (isset($conn->gid)) {
            unset($this->connectionsByGlobalId[$conn->gid]); // Remove the connection using the global device ID
        }

        if (isset($this->adminConnections[$conn->resourceId])) {
            unset($this->adminConnections[$conn->resourceId]);
            echo "Admin disconnected: {$conn->resourceId}\n";

        }
        $this->sendDeviceListToAdmin();

        // Notify admin of the disconnected device



        echo "Connection {$conn->resourceId} has disconnected\n";
    }

    public function onError(ConnectionInterface $conn, \Exception $e)
    {
        echo "An error has occurred: {$e->getMessage()}\n";
        $conn->close();
    }

    // Store dynamic current values into the database
    private function storeDynamicCurrents($data)
    {
        try {
            $res= $this->pdataCollectionSocket($data);
            echo "Stored currents for device : {$data['gid']}  \n  \n";
        } catch (\Exception $e) {
            echo "Failed to store currents: {$e->getMessage()}\n";
        }
    }

    // Process command to concern connection
    private function processCommand(ConnectionInterface $from, $command)
    {
        try {
            $sendTo=$command['gid'];
            if (isset($this->connectionsByGlobalId[$sendTo])) {
                $targetConnection = $this->connectionsByGlobalId[$sendTo];
                $targetConnection->send(json_encode($command));
                // print_r($command);
            }
            else
                echo 'connection not found \n';
        } catch (\Exception $e) {
            echo "error in process command: {$e->getMessage()}\n";
        }

    }

    private function do_action($from,$data)
    {
        // if (isset($this->connectionsByGlobalId['server_'.$data['gid']])) { // if dashboard need data for real time
        //     $new_data=$data;
        //     $new_data['gid']='server_'.$data['gid'];
        //     $this->processCommand($from,$new_data); // send command
        // }
        try {

            if($data['at']=='request')
            {
                if($data['a']=='ping')
                {
                        $msg=['gid'=>$data['gid'],'at'=>'response','a'=>'ping','d'=>['msg'=>'Hi']];
                        $this->processCommand($from,socket_data($msg));
                }
                else if($data['a']=='configuration_data') // pur testing purpose
                {
                    $d= $this->save_configuration_data($data);
                    $msg=['gid'=>$data['gid'],'at'=>'response','a'=>'configuration_data','d'=>['msg'=>'Only for Testing Purpose']];

                    $this->processCommand($from,socket_data($msg));
                }
                // get device info
                else if($data['a']=='get_info')
                {
                    $d= $this->get_info($data['gid']);
                    if($d)
                    {
                        $msg=['gid'=>$data['gid'],'at'=>'response','a'=>'get_info','d'=>$d];
                        $this->processCommand($from,socket_data($msg));
                    }
                    else
                        echo 'gid not found';
                }
                else if($data['a']=='get_tripping_event_setting')
                {
                    $d= $this->get_tripping_event_setting($data['gid']);
                    if($d)
                    {
                        $msg=['gid'=>$data['gid'],'at'=>'response','a'=>'get_tripping_event_setting','d'=>$d];
                        $this->processCommand($from,socket_data($msg));
                    }
                    else
                        echo 'gid not found';
                }

                else if($data['a']=='get_load_shedding')
                {
                    $d= $this->get_load_shedding($data['gid']);
                    if($d)
                    {
                        $msg=['gid'=>$data['gid'],'at'=>'response','a'=>'get_load_shedding','d'=>$d];
                        $this->processCommand($from,socket_data($msg));
                    }
                    else
                        echo 'gid not found';
                }
                else if($data['a']=='get_time_of_use')
                {
                    $d= $this->get_time_of_use($data['gid']);
                    if($d)
                    {
                        $msg=['gid'=>$data['gid'],'at'=>'response','a'=>'get_time_of_use','d'=>$d];
                        $this->processCommand($from,socket_data($msg));
                    }
                    else
                        echo 'gid not found';
                }
                


            }
            else if($data['at']=='event')
            {
                if($data['a']=='post_event')
                {
                    $d= $this->post_event($data);
                    $msg=['gid'=>$data['gid'],'at'=>'response','a'=>'post_event','d'=>$d];
                    $this->processCommand($from,socket_data($msg));
                }
                else
                    echo 'post event not run';

            }
            else if($data['at']=='post_data')
            {
                if($data['a']=='daily_billing')
                {
                    $d= $this->post_billing_data($data);
                    $msg=['gid'=>$data['gid'],'at'=>'response','a'=>'daily_billing','d'=>$d];
                    $this->processCommand($from,socket_data($msg));
                }
                else if($data['a']=='monthly_billing')
                {
                    $d= $this->post_monthly_billing_data($data);
                    $msg=['gid'=>$data['gid'],'at'=>'response','a'=>'monthly_billing','d'=>$d];
                    $this->processCommand($from,socket_data($msg));
                }
                else if($data['a']=='load_profile')
                {
                    $d= $this->load_profile($data);

                    $msg=['gid'=>$data['gid'],'at'=>'response','a'=>'load_profile','d'=>$d];
                    $this->processCommand($from,socket_data($msg));
                }
                else if($data['a']=='extra_log')
                {

                    $d= $this->extra_log($data);
                    // $msg=['gid'=>$data['gid'],'at'=>'response','a'=>'extra_log','d'=>$d];
                    // $this->processCommand($from,socket_data($msg));
                }
                else
                    echo 'data not post ';
            }
            else
            {
                echo 't4';
            }

        } catch (\Exception $e) {
            echo "Failed to store currents: {$e->getMessage()}\n";
        }


    }
    private function removeFromQue($data)
    {
        if($data['at']=='confirmation')
        {
            // get device info
            if($data['a']=='aux_relay_operation')
            {
                $d= $this->update_relay_status($data);

            }
            // else if($data['a']=='get_tripping_event_setting')
            // {

            // }
        }


        else
        {
            echo 'not comfirmation';
        }


    }

    private function setConnectionTimeout(ConnectionInterface $conn)
    {
        if ($conn instanceof ReactConnection) {
            // Set timeout to 10 minutes (600 seconds)
            $conn->stream->setTimeout(1800); // Apply 30-minute timeout to the connection stream
        }
    }

    private function sendDeviceListToAdmin()
    {
        // If there are any admin connections, send the updated device list
        if (!empty($this->adminConnections)) {
            // $deviceList = json_encode(array_values($this->connectionsByGlobalId));
            $msg=['gid'=>'11','at'=>'post_data','a'=>'send_connection_data','d'=>array_keys($this->connectionsByGlobalId)];
            // $this->processCommand($from,socket_data($msg));
            // print_r($this->adminConnections);

            // Send the updated list of devices only to the admin connections
            foreach ($this->adminConnections as $adminConn) {
                echo 'connection come ';
                $adminConn->send(json_encode(socket_data($msg)));
                //     // $this->processCommand($adminConn,socket_data($msg));
            }
        }
    }


    private function sendQuedCommandToDevice(ConnectionInterface $from, $gid)
    {
        $rec_check=Command::where('gid',$gid)->get();
        $targetConnection = $this->connectionsByGlobalId[$gid];
        foreach ($rec_check as $key => $list) {
            $targetConnection->send($list->command);
        }
    }
}
